// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/TextProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestTextProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        TextProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.alignment().has_value());
        QVERIFY(!property.font().has_value());
        QVERIFY(!property.color().has_value());
    }

    void testHasAnyValue()
    {
        TextProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setAlignment(AlignmentProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setAlignment(testAlignmentPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setAlignment(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            QFont value;
            property.setFont(value);
            QVERIFY(property.hasAnyValue());
            property.setFont(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            Union::Color value;
            property.setColor(value);
            QVERIFY(property.hasAnyValue());
            property.setColor(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        TextProperty source;
        TextProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        TextProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setAlignment(testAlignmentPropertyInstance());
        source.setFont(QFont{});
        source.setColor(Union::Color{});

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        TextProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.alignment(), source.alignment());
        QCOMPARE(destination.font(), source.font());
        QCOMPARE(destination.color(), source.color());
    }
};

QTEST_MAIN(TestTextProperty)

#include "TestTextProperty.moc"