// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from CreateTestInstances.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

#include <QtTest>

#include <properties/AlignmentProperty.h>
#include <properties/BackgroundProperty.h>
#include <properties/BorderProperty.h>
#include <properties/CornerProperty.h>
#include <properties/CornersProperty.h>
#include <properties/IconProperty.h>
#include <properties/ImageProperty.h>
#include <properties/LayoutProperty.h>
#include <properties/LineProperty.h>
#include <properties/OffsetProperty.h>
#include <properties/OutlineProperty.h>
#include <properties/ShadowProperty.h>
#include <properties/SizeProperty.h>
#include <properties/StyleProperty.h>
#include <properties/TextProperty.h>

using namespace Qt::StringLiterals;

namespace Union
{
namespace Properties
{

QColor testQColorInstance()
{
    return Qt::magenta;
}

qreal testQrealInstance()
{
    return 10.0;
}

QFont testQFontInstance()
{
    return QFont{u"Noto Sans"_s, 12};
}

std::unique_ptr<StyleProperty> testStylePropertyInstance();
std::unique_ptr<LayoutProperty> testLayoutPropertyInstance();
std::unique_ptr<AlignmentProperty> testAlignmentPropertyInstance();
std::unique_ptr<SizeProperty> testSizePropertyInstance();
std::unique_ptr<TextProperty> testTextPropertyInstance();
std::unique_ptr<IconProperty> testIconPropertyInstance();
std::unique_ptr<BackgroundProperty> testBackgroundPropertyInstance();
std::unique_ptr<ImageProperty> testImagePropertyInstance();
std::unique_ptr<BorderProperty> testBorderPropertyInstance();
std::unique_ptr<LineProperty> testLinePropertyInstance();
std::unique_ptr<OutlineProperty> testOutlinePropertyInstance();
std::unique_ptr<CornersProperty> testCornersPropertyInstance();
std::unique_ptr<CornerProperty> testCornerPropertyInstance();
std::unique_ptr<ShadowProperty> testShadowPropertyInstance();
std::unique_ptr<OffsetProperty> testOffsetPropertyInstance();

std::unique_ptr<StyleProperty> testStylePropertyInstance()
{
    auto instance = std::make_unique<StyleProperty>();

    instance->setLayout(testLayoutPropertyInstance());
    instance->setText(testTextPropertyInstance());
    instance->setIcon(testIconPropertyInstance());
    instance->setBackground(testBackgroundPropertyInstance());
    instance->setBorder(testBorderPropertyInstance());
    instance->setOutline(testOutlinePropertyInstance());
    instance->setCorners(testCornersPropertyInstance());
    instance->setShadow(testShadowPropertyInstance());

    return instance;
}

std::unique_ptr<LayoutProperty> testLayoutPropertyInstance()
{
    auto instance = std::make_unique<LayoutProperty>();

    instance->setAlignment(testAlignmentPropertyInstance());
    instance->setWidth(testQrealInstance());
    instance->setHeight(testQrealInstance());
    instance->setSpacing(testQrealInstance());
    instance->setPadding(testSizePropertyInstance());
    instance->setInset(testSizePropertyInstance());
    instance->setMargins(testSizePropertyInstance());

    return instance;
}

std::unique_ptr<AlignmentProperty> testAlignmentPropertyInstance()
{
    auto instance = std::make_unique<AlignmentProperty>();

    instance->setContainer(Union::Properties::AlignmentContainer{});
    instance->setHorizontal(Union::Properties::Alignment{});
    instance->setVertical(Union::Properties::Alignment{});
    instance->setOrder(int{});

    return instance;
}

std::unique_ptr<SizeProperty> testSizePropertyInstance()
{
    auto instance = std::make_unique<SizeProperty>();

    instance->setLeft(testQrealInstance());
    instance->setRight(testQrealInstance());
    instance->setTop(testQrealInstance());
    instance->setBottom(testQrealInstance());

    return instance;
}

std::unique_ptr<TextProperty> testTextPropertyInstance()
{
    auto instance = std::make_unique<TextProperty>();

    instance->setAlignment(testAlignmentPropertyInstance());
    instance->setFont(testQFontInstance());
    instance->setColor(Union::Color{});

    return instance;
}

std::unique_ptr<IconProperty> testIconPropertyInstance()
{
    auto instance = std::make_unique<IconProperty>();

    instance->setAlignment(testAlignmentPropertyInstance());
    instance->setWidth(testQrealInstance());
    instance->setHeight(testQrealInstance());
    instance->setName(QString{});
    instance->setSource(QUrl{});
    instance->setColor(Union::Color{});

    return instance;
}

std::unique_ptr<BackgroundProperty> testBackgroundPropertyInstance()
{
    auto instance = std::make_unique<BackgroundProperty>();

    instance->setColor(Union::Color{});
    instance->setImage(testImagePropertyInstance());

    return instance;
}

std::unique_ptr<ImageProperty> testImagePropertyInstance()
{
    auto instance = std::make_unique<ImageProperty>();

    instance->setSource(std::filesystem::path{});
    instance->setWidth(testQrealInstance());
    instance->setHeight(testQrealInstance());
    instance->setXOffset(testQrealInstance());
    instance->setYOffset(testQrealInstance());
    instance->setFlags(Union::Properties::ImageFlags{});
    instance->setMaskColor(Union::Color{});

    return instance;
}

std::unique_ptr<BorderProperty> testBorderPropertyInstance()
{
    auto instance = std::make_unique<BorderProperty>();

    instance->setLeft(testLinePropertyInstance());
    instance->setRight(testLinePropertyInstance());
    instance->setTop(testLinePropertyInstance());
    instance->setBottom(testLinePropertyInstance());

    return instance;
}

std::unique_ptr<LineProperty> testLinePropertyInstance()
{
    auto instance = std::make_unique<LineProperty>();

    instance->setSize(testQrealInstance());
    instance->setColor(Union::Color{});
    instance->setStyle(Union::Properties::LineStyle{});
    instance->setImage(testImagePropertyInstance());

    return instance;
}

std::unique_ptr<OutlineProperty> testOutlinePropertyInstance()
{
    auto instance = std::make_unique<OutlineProperty>();

    instance->setLeft(testLinePropertyInstance());
    instance->setRight(testLinePropertyInstance());
    instance->setTop(testLinePropertyInstance());
    instance->setBottom(testLinePropertyInstance());

    return instance;
}

std::unique_ptr<CornersProperty> testCornersPropertyInstance()
{
    auto instance = std::make_unique<CornersProperty>();

    instance->setTopLeft(testCornerPropertyInstance());
    instance->setTopRight(testCornerPropertyInstance());
    instance->setBottomLeft(testCornerPropertyInstance());
    instance->setBottomRight(testCornerPropertyInstance());

    return instance;
}

std::unique_ptr<CornerProperty> testCornerPropertyInstance()
{
    auto instance = std::make_unique<CornerProperty>();

    instance->setRadius(testQrealInstance());
    instance->setWidth(testQrealInstance());
    instance->setHeight(testQrealInstance());
    instance->setColor(Union::Color{});
    instance->setImage(testImagePropertyInstance());

    return instance;
}

std::unique_ptr<ShadowProperty> testShadowPropertyInstance()
{
    auto instance = std::make_unique<ShadowProperty>();

    instance->setOffset(testOffsetPropertyInstance());
    instance->setColor(Union::Color{});
    instance->setSize(testQrealInstance());
    instance->setBlur(testQrealInstance());
    instance->setLeft(testLinePropertyInstance());
    instance->setRight(testLinePropertyInstance());
    instance->setTop(testLinePropertyInstance());
    instance->setBottom(testLinePropertyInstance());
    instance->setTopLeft(testCornerPropertyInstance());
    instance->setTopRight(testCornerPropertyInstance());
    instance->setBottomLeft(testCornerPropertyInstance());
    instance->setBottomRight(testCornerPropertyInstance());

    return instance;
}

std::unique_ptr<OffsetProperty> testOffsetPropertyInstance()
{
    auto instance = std::make_unique<OffsetProperty>();

    instance->setHorizontal(testQrealInstance());
    instance->setVertical(testQrealInstance());

    return instance;
}
}
}