// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/BorderProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestBorderProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testNull()
    {
        auto property = std::make_unique<BorderProperty>();

        // A null instance should not have any values for its properties.
        QVERIFY(!property->left());
        QVERIFY(!property->right());
        QVERIFY(!property->top());
        QVERIFY(!property->bottom());
    }

    void testEmpty()
    {
        auto property = BorderProperty::empty();

        // An empty instance should only have values that are considered "empty".
        QCOMPARE(*property->left(), *LineProperty::empty());
        QCOMPARE(*property->right(), *LineProperty::empty());
        QCOMPARE(*property->top(), *LineProperty::empty());
        QCOMPARE(*property->bottom(), *LineProperty::empty());
    }

    void testHasAnyValue()
    {
        auto property = std::make_unique<BorderProperty>();

        // An empty instance should not have any values for its properties.
        QVERIFY(!property->hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property->setLeft(std::make_unique<LineProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setLeft(testLinePropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setLeft(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setRight(std::make_unique<LineProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setRight(testLinePropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setRight(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setTop(std::make_unique<LineProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setTop(testLinePropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setTop(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setBottom(std::make_unique<LineProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setBottom(testLinePropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setBottom(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        auto source = std::make_unique<BorderProperty>();
        auto destination = std::make_unique<BorderProperty>();

        QVERIFY(!source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        BorderProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(!destination->hasAnyValue());

        source->setLeft(testLinePropertyInstance());
        source->setRight(testLinePropertyInstance());
        source->setTop(testLinePropertyInstance());
        source->setBottom(testLinePropertyInstance());

        QVERIFY(source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        BorderProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(destination->hasAnyValue());

        QCOMPARE(*destination->left(), *source->left());
        QCOMPARE(*destination->right(), *source->right());
        QCOMPARE(*destination->top(), *source->top());
        QCOMPARE(*destination->bottom(), *source->bottom());
    }
};

QTEST_MAIN(TestBorderProperty)

#include "TestBorderProperty.moc"