// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/CornersProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestCornersProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testNull()
    {
        auto property = std::make_unique<CornersProperty>();

        // A null instance should not have any values for its properties.
        QVERIFY(!property->topLeft());
        QVERIFY(!property->topRight());
        QVERIFY(!property->bottomLeft());
        QVERIFY(!property->bottomRight());
    }

    void testEmpty()
    {
        auto property = CornersProperty::empty();

        // An empty instance should only have values that are considered "empty".
        QCOMPARE(*property->topLeft(), *CornerProperty::empty());
        QCOMPARE(*property->topRight(), *CornerProperty::empty());
        QCOMPARE(*property->bottomLeft(), *CornerProperty::empty());
        QCOMPARE(*property->bottomRight(), *CornerProperty::empty());
    }

    void testHasAnyValue()
    {
        auto property = std::make_unique<CornersProperty>();

        // An empty instance should not have any values for its properties.
        QVERIFY(!property->hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property->setTopLeft(std::make_unique<CornerProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setTopLeft(testCornerPropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setTopLeft(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setTopRight(std::make_unique<CornerProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setTopRight(testCornerPropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setTopRight(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setBottomLeft(std::make_unique<CornerProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setBottomLeft(testCornerPropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setBottomLeft(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property->setBottomRight(std::make_unique<CornerProperty>());
            QVERIFY(!property->hasAnyValue());

            property->setBottomRight(testCornerPropertyInstance());
            QVERIFY(property->hasAnyValue());

            property->setBottomRight(nullptr);
            QVERIFY(!property->hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        auto source = std::make_unique<CornersProperty>();
        auto destination = std::make_unique<CornersProperty>();

        QVERIFY(!source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        CornersProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(!destination->hasAnyValue());

        source->setTopLeft(testCornerPropertyInstance());
        source->setTopRight(testCornerPropertyInstance());
        source->setBottomLeft(testCornerPropertyInstance());
        source->setBottomRight(testCornerPropertyInstance());

        QVERIFY(source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        CornersProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(destination->hasAnyValue());

        QCOMPARE(*destination->topLeft(), *source->topLeft());
        QCOMPARE(*destination->topRight(), *source->topRight());
        QCOMPARE(*destination->bottomLeft(), *source->bottomLeft());
        QCOMPARE(*destination->bottomRight(), *source->bottomRight());
    }
};

QTEST_MAIN(TestCornersProperty)

#include "TestCornersProperty.moc"