// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/SizeProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestSizeProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testNull()
    {
        auto property = std::make_unique<SizeProperty>();

        // A null instance should not have any values for its properties.
        QVERIFY(!property->left().has_value());
        QVERIFY(!property->right().has_value());
        QVERIFY(!property->top().has_value());
        QVERIFY(!property->bottom().has_value());
    }

    void testEmpty()
    {
        auto property = SizeProperty::empty();

        // An empty instance should only have values that are considered "empty".
        QCOMPARE(property->left().value(), emptyValue<qreal>());
        QCOMPARE(property->right().value(), emptyValue<qreal>());
        QCOMPARE(property->top().value(), emptyValue<qreal>());
        QCOMPARE(property->bottom().value(), emptyValue<qreal>());
    }

    void testHasAnyValue()
    {
        auto property = std::make_unique<SizeProperty>();

        // An empty instance should not have any values for its properties.
        QVERIFY(!property->hasAnyValue());

        {
            qreal value;
            property->setLeft(value);
            QVERIFY(property->hasAnyValue());
            property->setLeft(std::nullopt);
            QVERIFY(!property->hasAnyValue());
        }
        {
            qreal value;
            property->setRight(value);
            QVERIFY(property->hasAnyValue());
            property->setRight(std::nullopt);
            QVERIFY(!property->hasAnyValue());
        }
        {
            qreal value;
            property->setTop(value);
            QVERIFY(property->hasAnyValue());
            property->setTop(std::nullopt);
            QVERIFY(!property->hasAnyValue());
        }
        {
            qreal value;
            property->setBottom(value);
            QVERIFY(property->hasAnyValue());
            property->setBottom(std::nullopt);
            QVERIFY(!property->hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        auto source = std::make_unique<SizeProperty>();
        auto destination = std::make_unique<SizeProperty>();

        QVERIFY(!source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        SizeProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(!destination->hasAnyValue());

        source->setLeft(qreal{});
        source->setRight(qreal{});
        source->setTop(qreal{});
        source->setBottom(qreal{});

        QVERIFY(source->hasAnyValue());
        QVERIFY(!destination->hasAnyValue());

        SizeProperty::resolveProperties(source.get(), destination.get());

        QVERIFY(destination->hasAnyValue());

        QCOMPARE(destination->left(), source->left());
        QCOMPARE(destination->right(), source->right());
        QCOMPARE(destination->top(), source->top());
        QCOMPARE(destination->bottom(), source->bottom());
    }
};

QTEST_MAIN(TestSizeProperty)

#include "TestSizeProperty.moc"